unit SmThreadUnit;

interface

uses
  Classes, Controls, SysUtils, StdCtrls, ExtCtrls, DateUtils;

type
  TSmThread = class(TThread)
  private
    fRep     : TMemo;     //     
    fPanel   : TPanel;    //  
    fEd1     : TEdit;     //  
    fTID     : cardinal;  //  
    fTCur    : TDateTime;
    fTOld    : TDateTime;
    fPrefix  : string;
    fCount   : cardinal;  //    
    procedure BuildDynamic();
    procedure FreeDynamic();
  protected
    procedure Execute; override;
    procedure ExOnTerminate(Sender : TObject);
    procedure TMTReports();
  public
    constructor Create(RqPanel : TPanel; RqRep : TMemo);
    property Prefix  : string read fPrefix write fPrefix;
end;

implementation

// ----------------------------------------------------------------
//  
// ----------------------------------------------------------------
// lass-reference.  ,    ,
//     TControl
type TControlClass = class of TControl;

// ----------------------------------------------------------------
//   ,   TControl.
//  CreateControl    class () 
// ,      RqOwner
// (,  Form1).

function CreateControl(ControlClass  : TControlClass;
                       RqOwner       : TWinControl;
                 const ComponentName : string;
                      X, Y, W, H     : Integer): TControl;
begin
    Result := ControlClass.Create(RqOwner);
    with Result do
    begin
      Parent := RqOwner;                   //    
      Name := ComponentName;               //   
      SetBounds(X, Y, W, H);               //   TWinControl
      Visible := True;                     //   
    end;
end;

// ----------------------------------------------------------------
//     TSmThread
// ----------------------------------------------------------------

//     
procedure TSmThread.BuildDynamic();
var WName : string;
begin
  try
    WName := 'Ed1ID' + IntToStr(fTID);
    fEd1  := (CreateControl(TEdit,fPanel,WName,10,10,100,24) as TEdit);
    fEd1.Text := 'Thead ID:' + IntToStr(fTID);
  except
    fEd1  := nil;
  end;
end;

//     
procedure TSmThread.FreeDynamic();
begin
   if Assigned(fEd1) then fEd1.Free;
end;

constructor TSmThread.Create(RqPanel : TPanel; RqRep : TMemo);
begin
  inherited Create(True);
  fTID := ThreadID;
  fPanel := RqPanel;
  fRep   := RqRep;
  fTOld  := Now;
  fTCur  := fTOld;
  //     
  BuildDynamic();
  //    
  OnTerminate := ExOnTerminate;
end;

//   
procedure TSmThread.Execute;
begin
  fCount := 0;
  repeat
    fTOld := fTCur;  //    
    fTCur := Now;    //   
    Synchronize(TMTReports);
    fCount := fCount + 1;
    Suspend;
  until (fCount > 1000) or Terminated;
end;

procedure TSmThread.ExOnTerminate(Sender : TObject);
begin
   //     
   Synchronize(FreeDynamic);
   //    
   fTID := 0;
end;

//  (Sinhronize)
procedure TSmThread.TMTReports();
var WStr : string;
begin
   if not Assigned(fRep) then Exit;
   //   
   WStr := fPrefix + 'ID:'
           + IntToStr(fTID)
           + '  count='
           + IntToStr(fCount)
           + '  d(ms)='
           + IntToStr(MilliSecondsBetween(fTCur, fTOld));
   // 
   fRep.Lines.Add(WStr);
end;


end.
 